/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.SafeDeleter;

public class ChangesMaker {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Map<Plugin, Boolean> allPlugins;

    public ChangesMaker(Map<Plugin, Boolean> allPlugins) {
        this.allPlugins = allPlugins;
    }

    public ProcessBuilder getProcessBuilder(File moveFile, File installFile, File restartFile) throws IOException {
        String jarPath = PluginManager.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (!jarPath.endsWith(".jar")) {
            log.warn("Suspicious JAR path detected: " + jarPath);
        }
        File currentJar = new File(jarPath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(SafeDeleter.getJVM());
        command.add("-classpath");
        command.add(URLDecoder.decode(currentJar.getPath(), "UTF-8"));
        command.add(SafeDeleter.class.getCanonicalName());
        command.add("--move-list");
        command.add(moveFile.getAbsolutePath());
        command.add("--install-list");
        command.add(installFile.getAbsolutePath());
        if (restartFile != null) {
            command.add("--restart-command");
            command.add(restartFile.getAbsolutePath());
        }
        log.debug("Command to execute: " + command);
        ProcessBuilder builder = new ProcessBuilder(command);
        File cleanerLog = File.createTempFile("jpgc-cleaner-", ".log");
        builder.redirectError(cleanerLog);
        builder.redirectOutput(cleanerLog);
        return builder;
    }

    public File getRestartFile(LinkedList<String> additionalJMeterOptions) throws IOException {
        File file = File.createTempFile("jpgc-restart-", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            out.print(SafeDeleter.getJVM() + "\n");
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> jvmArgs = runtimeMXBean.getInputArguments();
            for (String arg : jvmArgs) {
                out.print(arg + "\n");
            }
            out.print("-jar\n");
            out.print(this.getJMeterStartCommand(additionalJMeterOptions));
            File file2 = file;
            return file2;
        }
    }

    private String getJMeterStartCommand(LinkedList<String> additionalJMeterOptions) {
        StringBuilder cmd = new StringBuilder(JMeterUtils.getJMeterBinDir() + File.separator + "ApacheJMeter.jar\n");
        if (additionalJMeterOptions != null) {
            for (String option : additionalJMeterOptions) {
                cmd.append(option).append("\n");
            }
        }
        return cmd.toString();
    }

    public File getInstallFile(Set<Plugin> plugins) throws IOException {
        File file = File.createTempFile("jpgc-installers-", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            for (Plugin plugin : plugins) {
                String cls = plugin.getInstallerClass();
                if (cls == null) continue;
                log.debug("Plugin " + plugin + " has installer: " + cls);
                out.print(plugin.getDestName() + "\t" + cls + "\n");
            }
            File file2 = file;
            return file2;
        }
    }

    public File getMovementsFile(Set<Plugin> deletes, Set<Plugin> installs, Map<String, String> installLibs, Set<String> libDeletions) throws IOException {
        File file = File.createTempFile("jpgc-jar-changes", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            if (!deletes.isEmpty() || !libDeletions.isEmpty()) {
                String delTo;
                Object installed;
                File delDir = File.createTempFile("jpgc-deleted-jars-", "");
                delDir.delete();
                delDir.mkdir();
                log.info("Will move deleted JARs to directory " + delDir);
                for (Plugin plugin : deletes) {
                    installed = new File(plugin.getInstalledPath());
                    delTo = delDir + File.separator + ((File)installed).getName();
                    out.print(plugin.getInstalledPath() + "\t" + delTo + "\n");
                }
                for (String string : libDeletions) {
                    for (Plugin plugin : this.allPlugins.keySet()) {
                        if (!plugin.isInstalled() || !plugin.getInstalledPath().equals(string)) continue;
                        log.warn("Cannot delete " + string + " since it is part of plugin " + plugin);
                        libDeletions.remove(string);
                    }
                }
                for (String string : libDeletions) {
                    installed = new File(string);
                    delTo = delDir + File.separator + ((File)installed).getName();
                    out.print(string + "\t" + delTo + "\n");
                }
            }
            String libPath = new File(JOrphanUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParent();
            for (Map.Entry<String, String> entry : installLibs.entrySet()) {
                out.print(entry.getKey() + "\t" + URLDecoder.decode(libPath, "UTF-8") + File.separator + entry.getValue() + "\n");
            }
            for (Plugin plugin : installs) {
                out.print(plugin.getTempName() + "\t" + plugin.getDestName() + "\n");
            }
            Iterator<String> iterator = file;
            return iterator;
        }
    }
}

