/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.Library;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;

public class DependencyResolver {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Pattern libNameParser = Pattern.compile("([^=<>]+)([=<>]+[0-9.]+)?");
    public static final String JAVA_CLASS_PATH = "java.class.path";
    protected final Set<Plugin> deletions = new HashSet<Plugin>();
    protected final Set<Plugin> additions = new HashSet<Plugin>();
    protected final Map<String, String> libAdditions = new HashMap<String, String>();
    protected final Set<String> libDeletions = new HashSet<String>();
    protected final Map<Plugin, Boolean> allPlugins;

    public DependencyResolver(Map<Plugin, Boolean> allPlugins) {
        this.allPlugins = allPlugins;
        this.resolve();
    }

    public void resolve() {
        this.clear();
        this.resolveFlags();
        this.resolveUpgrades();
        this.resolveDeleteByDependency();
        this.resolveInstallByDependency();
        this.resolveDeleteLibs();
        this.resolveInstallLibs();
        this.resolveUpgradesLibs();
        this.detectConflicts();
    }

    public void clear() {
        this.deletions.clear();
        this.additions.clear();
        this.libAdditions.clear();
        this.libDeletions.clear();
    }

    public Set<Plugin> getDeletions() {
        return this.deletions;
    }

    public Set<Plugin> getAdditions() {
        return this.additions;
    }

    public Map<String, String> getLibAdditions() {
        return this.libAdditions;
    }

    public Set<String> getLibDeletions() {
        return this.libDeletions;
    }

    private Plugin getPluginByID(String id) {
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.getID().equals(id)) continue;
            return plugin;
        }
        throw new RuntimeException("Plugin not found by ID: " + id);
    }

    private Set<Plugin> getDependants(Plugin plugin) {
        HashSet<Plugin> res = new HashSet<Plugin>();
        for (Plugin pAll : this.allPlugins.keySet()) {
            for (String depID : pAll.getDepends()) {
                if (!depID.equals(plugin.getID())) continue;
                res.add(pAll);
            }
        }
        return res;
    }

    private void resolveFlags() {
        for (Map.Entry<Plugin, Boolean> entry : this.allPlugins.entrySet()) {
            if (entry.getKey().isInstalled()) {
                if (entry.getValue().booleanValue()) continue;
                this.deletions.add(entry.getKey());
                continue;
            }
            if (!entry.getValue().booleanValue()) continue;
            this.additions.add(entry.getKey());
        }
    }

    private void resolveUpgrades() {
        for (Map.Entry<Plugin, Boolean> entry : this.allPlugins.entrySet()) {
            Plugin plugin = entry.getKey();
            if (!entry.getValue().booleanValue() || !plugin.isInstalled() || plugin.getInstalledVersion().equals(plugin.getCandidateVersion())) continue;
            log.debug("Upgrade: " + plugin);
            this.deletions.add(plugin);
            this.additions.add(plugin);
        }
    }

    private void resolveDeleteByDependency() {
        boolean hasModifications = true;
        block0: while (hasModifications) {
            log.debug("Check uninstall dependencies");
            hasModifications = false;
            for (Plugin plugin : this.deletions) {
                if (!this.additions.contains(plugin)) {
                    for (Plugin dep : this.getDependants(plugin)) {
                        if (!this.deletions.contains(dep) && dep.isInstalled()) {
                            log.debug("Add to deletions: " + dep);
                            this.deletions.add(dep);
                            hasModifications = true;
                        }
                        if (!this.additions.contains(dep)) continue;
                        log.debug("Remove from additions: " + dep);
                        this.additions.remove(dep);
                        hasModifications = true;
                    }
                }
                if (!hasModifications) continue;
                continue block0;
            }
        }
    }

    private void resolveInstallByDependency() {
        boolean hasModifications = true;
        block0: while (hasModifications) {
            log.debug("Check install dependencies: " + this.additions);
            hasModifications = false;
            for (Plugin plugin : this.additions) {
                for (String pluginID : plugin.getDepends()) {
                    Plugin depend = this.getPluginByID(pluginID);
                    if (depend.isInstalled() && !this.deletions.contains(depend) || this.additions.contains(depend)) continue;
                    log.debug("Add to install: " + depend);
                    this.additions.add(depend);
                    hasModifications = true;
                }
                if (!hasModifications) continue;
                continue block0;
            }
        }
    }

    private void resolveInstallLibs() {
        for (Plugin plugin : this.additions) {
            Map<String, String> libs = plugin.getLibs(plugin.getCandidateVersion());
            for (String lib : libs.keySet()) {
                this.resolveLibForPlugin(plugin, lib, libs.get(lib));
            }
        }
        this.resolveLibsVersionsConflicts();
    }

    private void resolveLibForPlugin(Plugin plugin, String lib, String link) {
        String installedPath = Plugin.getLibInstallPath(DependencyResolver.getLibName(lib));
        if (installedPath == null) {
            this.libAdditions.put(lib, link);
        } else {
            this.resolveUpdateLib(plugin, this.getLibrary(lib, ""), lib);
        }
    }

    private void resolveUpdateLib(Plugin plugin, Library installedLib, String candidateLibName) {
        Map<String, String> candidateLibs = plugin.getLibs(plugin.getCandidateVersion());
        Library candidateLib = this.getLibrary(candidateLibName, candidateLibs.get(candidateLibName));
        String installedPath = Plugin.getLibInstallPath(installedLib.getName());
        if (installedPath == null) {
            this.libAdditions.put(candidateLib.getName(), candidateLib.getLink());
            return;
        }
        String installedVersion = Plugin.getVersionFromPath(installedPath);
        installedLib.setVersion(installedVersion);
        if (candidateLib.getVersion() != null && Library.versionComparator.compare(installedLib, candidateLib) < 0) {
            this.libDeletions.add(installedLib.getName());
            this.libAdditions.put(candidateLib.getName(), candidateLib.getLink());
        }
    }

    private void resolveDeleteLibs() {
        for (Plugin plugin : this.deletions) {
            if (this.additions.contains(plugin)) continue;
            Map<String, String> libs = plugin.getLibs(plugin.getInstalledVersion());
            for (String lib : libs.keySet()) {
                String name = DependencyResolver.getLibName(lib);
                if (Plugin.getLibInstallPath(name) != null) {
                    this.libDeletions.add(name);
                    continue;
                }
                log.warn("Did not find library to uninstall it: " + lib);
            }
        }
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!this.additions.contains(plugin) && (!plugin.isInstalled() || this.deletions.contains(plugin))) continue;
            String ver = this.additions.contains(plugin) ? plugin.getCandidateVersion() : plugin.getInstalledVersion();
            Map<String, String> libs = plugin.getLibs(ver);
            for (String lib : libs.keySet()) {
                String name = DependencyResolver.getLibName(lib);
                if (!this.libDeletions.contains(name)) continue;
                log.debug("Won't delete lib " + lib + " since it is used by " + plugin);
                this.libDeletions.remove(name);
            }
        }
    }

    private void resolveUpgradesLibs() {
        for (Plugin plugin : this.deletions) {
            if (!this.additions.contains(plugin)) continue;
            Map<String, String> installedLibs = plugin.getLibs(plugin.getInstalledVersion());
            Map<String, String> candidateLibs = plugin.getLibs(plugin.getCandidateVersion());
            for (String candidateLibName : candidateLibs.keySet()) {
                String installedLibName = this.getMatchLibName(candidateLibName, installedLibs);
                if (installedLibName == null) continue;
                this.resolveUpdateLib(plugin, this.getLibrary(installedLibName, installedLibs.get(installedLibName)), candidateLibName);
            }
        }
    }

    private String getMatchLibName(String candidateLibName, Map<String, String> installedLibs) {
        String candidateName = DependencyResolver.getLibName(candidateLibName);
        for (String installedLibName : installedLibs.keySet()) {
            if (!installedLibName.startsWith(candidateName) || !DependencyResolver.getLibName(installedLibName).equals(candidateName)) continue;
            return installedLibName;
        }
        return null;
    }

    public static String getLibName(String fullLibName) {
        Matcher m = libNameParser.matcher(fullLibName);
        if (!m.find()) {
            throw new IllegalArgumentException("Cannot parse str: " + fullLibName);
        }
        return m.group(1);
    }

    private Library getLibrary(String fullLibName, String link) {
        Matcher m = libNameParser.matcher(fullLibName);
        if (!m.find()) {
            throw new IllegalArgumentException("Cannot parse str: " + fullLibName);
        }
        String name = m.group(1);
        if (m.groupCount() == 2 && m.group(2) != null && !m.group(2).isEmpty()) {
            String condition = m.group(2).substring(0, 2);
            this.verifyConditionFormat(condition);
            String version = m.group(2).substring(2);
            return new Library(name, version, link);
        }
        return new Library(name, link);
    }

    private void resolveLibsVersionsConflicts() {
        HashMap<String, Object> libsToResolve = new HashMap<String, Object>();
        for (String key : this.libAdditions.keySet()) {
            Library library = this.getLibrary(key, this.libAdditions.get(key));
            if (library.getVersion() == null) continue;
            if (libsToResolve.containsKey(library.getName())) {
                ((List)libsToResolve.get(library.getName())).add(library);
                continue;
            }
            ArrayList libs = new ArrayList();
            libs.add(library);
            libsToResolve.put(library.getName(), libs);
        }
        for (String key : libsToResolve.keySet()) {
            List libs = (List)libsToResolve.get(key);
            Collections.sort(libs, Library.versionComparator);
            for (Library lib : libs) {
                this.libAdditions.remove(lib.getFullName());
            }
            Library libToInstall = (Library)libs.get(libs.size() - 1);
            this.libAdditions.put(libToInstall.getName(), libToInstall.getLink());
        }
    }

    protected void verifyConditionFormat(String condition) {
        if (!condition.equals(">=")) {
            throw new IllegalArgumentException("Expected conditions are ['>='], but was: " + condition);
        }
    }

    public void detectConflicts() {
        Set<Plugin> installedPlugins = PluginManager.getInstalledPlugins(this.allPlugins);
        for (Plugin plugin : installedPlugins) {
            Map<String, String> requiredLibs = plugin.getLibs(plugin.getInstalledVersion());
            for (String lib : requiredLibs.keySet()) {
                this.resolveLibForPlugin(plugin, lib, requiredLibs.get(lib));
            }
        }
    }
}

