/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.io.FileUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.JARSource;

public class JARSourceFilesystem
extends JARSource {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final File base;
    private File jsonFile;

    public JARSourceFilesystem(File jsonFile) {
        this.jsonFile = jsonFile;
        this.base = jsonFile.getParentFile();
    }

    @Override
    public JSON getRepo() throws IOException {
        return JSONSerializer.toJSON((Object)FileUtils.readFileToString((File)this.jsonFile), new JsonConfig());
    }

    @Override
    public void reportStats(String[] usageStats) throws IOException {
        log.debug("Not reporting stats");
    }

    @Override
    public void setTimeout(int timeout) {
        log.debug("Filesystem does not care of timeout");
    }

    @Override
    public JARSource.DownloadResult getJAR(String id, String location, GenericCallback<String> statusChanged) throws IOException {
        File orig = new File(this.base.getAbsolutePath() + File.separator + location);
        File tmp = File.createTempFile("jpgc-", ".jar");
        FileUtils.copyFile((File)orig, (File)tmp);
        return new JARSource.DownloadResult(this, tmp.getAbsolutePath(), orig.getName());
    }
}

