/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.JARSource;
import org.jmeterplugins.repository.http.HttpRetryStrategy;

public class JARSourceHTTP
extends JARSource {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int RETRY_COUNT = 1;
    private final String[] addresses;
    protected AbstractHttpClient httpClient = new DefaultHttpClient();
    private int timeout = 1000;
    private final ServiceUnavailableRetryStrategy retryStrategy = new HttpRetryStrategy(1, 5000);

    public JARSourceHTTP(String jmProp) {
        this.addresses = jmProp.split("[;]");
        this.httpClient = this.getHTTPClient();
    }

    private AbstractHttpClient getHTTPClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        String proxyHost = System.getProperty("https.proxyHost", "");
        if (!proxyHost.isEmpty()) {
            int proxyPort = Integer.parseInt(System.getProperty("https.proxyPort", "-1"));
            log.info("Using proxy " + proxyHost + ":" + proxyPort);
            HttpParams params = client.getParams();
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            params.setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser", JMeterUtils.getProperty((String)"http.proxyUser"));
            if (proxyUser != null) {
                String localHost;
                log.info("Using authenticated proxy with username: " + proxyUser);
                String proxyPass = System.getProperty("http.proxyPass", JMeterUtils.getProperty((String)"http.proxyPass"));
                try {
                    localHost = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (Throwable e) {
                    log.error("Failed to get local host name, defaulting to 'localhost'", e);
                    localHost = "localhost";
                }
                AuthScope authscope = new AuthScope(proxyHost, proxyPort);
                String proxyDomain = JMeterUtils.getPropDefault((String)"http.proxyDomain", (String)"");
                NTCredentials credentials = new NTCredentials(proxyUser, proxyPass, localHost, proxyDomain);
                client.getCredentialsProvider().setCredentials(authscope, (Credentials)credentials);
            }
        }
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, true));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSON getJSON(String uri) throws IOException {
        log.debug("Requesting " + uri);
        HttpGet get = new HttpGet(uri);
        HttpParams requestParams = get.getParams();
        requestParams.setIntParameter("http.socket.timeout", this.timeout);
        requestParams.setIntParameter("http.connection.timeout", this.timeout);
        HttpResponse result = this.execute((HttpUriRequest)get);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpEntity entity = result.getEntity();
        try {
            entity.writeTo((OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            if (bytes == null) {
                bytes = "null".getBytes();
            }
            String response = new String(bytes);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                log.warn("Response with code " + result + ": " + response);
                throw new IOException("Repository responded with wrong status code: " + statusCode);
            }
            log.debug("Response with code " + result + ": " + response);
            JSON jSON = JSONSerializer.toJSON((Object)response, new JsonConfig());
            return jSON;
        }
        finally {
            get.abort();
            try {
                entity.getContent().close();
            }
            catch (IOException | IllegalStateException e) {
                log.warn("Exception in finalizing request", (Throwable)e);
            }
        }
    }

    protected JSONArray getRepositories(String path) throws IOException {
        ArrayList<JSON> repositories = new ArrayList<JSON>(this.addresses.length);
        for (String address : this.addresses) {
            repositories.add(this.getJSON(address + path));
        }
        JSONArray result = new JSONArray();
        ArrayList<String> pluginsIDs = new ArrayList<String>();
        for (JSON json : repositories) {
            if (!(json instanceof JSONArray)) {
                throw new RuntimeException("Result is not array");
            }
            for (Object elm : (JSONArray)json) {
                String id = ((JSONObject)elm).getString("id");
                if (!pluginsIDs.contains(id)) {
                    pluginsIDs.add(id);
                    result.add(elm);
                    continue;
                }
                log.info("Plugin " + id + " will be skipped, because it is duplicated.");
            }
        }
        return result;
    }

    @Override
    public JSON getRepo() throws IOException {
        return this.getRepositories("?installID=" + this.getInstallID());
    }

    public String getInstallID() {
        String str = "";
        str = str + this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
        try {
            str = str + "\t" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot get local host name", (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(ifs)) {
                str = str + "\t" + Arrays.toString(netint.getHardwareAddress());
            }
        }
        catch (SocketException e) {
            log.warn("Failed to get network addresses", (Throwable)e);
        }
        return this.getPlatformName() + '-' + DigestUtils.md5Hex((String)str) + '-' + this.getGuiMode();
    }

    private String getGuiMode() {
        return GuiPackage.getInstance() == null ? "nongui" : "gui";
    }

    protected String getPlatformName() {
        if (this.containsEnvironment("JENKINS_HOME")) {
            return "jenkins";
        }
        if (this.containsEnvironment("TRAVIS")) {
            return "travis";
        }
        if (this.containsEnvironmentPrefix("bamboo")) {
            return "bamboo";
        }
        if (this.containsEnvironment("TEAMCITY_VERSION")) {
            return "teamcity";
        }
        if (this.containsEnvironment("DOCKER_HOST")) {
            return "docker";
        }
        if (this.containsEnvironmentPrefix("AWS_")) {
            return "amazon";
        }
        if (this.containsEnvironment("GOOGLE_APPLICATION_CREDENTIALS") || this.containsEnvironment("CLOUDSDK_CONFIG")) {
            return "google_cloud";
        }
        if (this.containsEnvironment("WEBJOBS_NAME")) {
            return "azure";
        }
        return this.getOSName();
    }

    private boolean containsEnvironment(String key) {
        return System.getenv().containsKey(key);
    }

    private boolean containsEnvironmentPrefix(String prefix) {
        for (String key : System.getenv().keySet()) {
            if (!key.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String getOSName() {
        return System.getProperty("os.name").toLowerCase().replace(' ', '_');
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * Exception decompiling
     */
    @Override
    public JARSource.DownloadResult getJAR(String id, String location, GenericCallback<String> callback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportStats(String[] usageStats) throws IOException {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add(this.getInstallID());
        Collections.addAll(stats, usageStats);
        for (String uri : this.addresses) {
            HttpPost post = null;
            try {
                post = new HttpPost(uri);
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                StringEntity body = new StringEntity("stats=" + URLEncoder.encode(Arrays.toString(stats.toArray(new String[0])), "UTF-8"));
                post.setEntity((HttpEntity)body);
                HttpParams requestParams = post.getParams();
                requestParams.setIntParameter("http.socket.timeout", 3000);
                requestParams.setIntParameter("http.connection.timeout", 1000);
                log.debug("Requesting " + uri);
                this.execute((HttpUriRequest)post);
            }
            finally {
                if (post != null) {
                    try {
                        post.abort();
                    }
                    catch (Exception e) {
                        log.warn("Failure while aborting POST", (Throwable)e);
                    }
                }
            }
        }
    }

    private static long copyLarge(InputStream input, OutputStream output, GenericCallback<Long> progressCallback) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            progressCallback.notify(count);
            count += (long)n;
        }
        return count;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.execute(request, null);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        int c = 1;
        while (true) {
            block8: {
                HttpResponse response = this.httpClient.execute(request, context);
                try {
                    if (this.retryStrategy.retryRequest(response, c, context)) {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        long nextInterval = this.retryStrategy.getRetryInterval();
                        try {
                            log.debug("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return response;
                }
                catch (RuntimeException ex) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException ioex) {
                        log.warn("I/O error consuming response content", (Throwable)ioex);
                    }
                    throw ex;
                }
            }
            ++c;
        }
    }
}

