/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.JARSource;

public class Plugin {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Pattern dependsParser = Pattern.compile("([^=<>]+)([=<>]+[0-9.]+)?");
    public static final String VER_STOCK = "0.0.0-STOCK";
    protected JSONObject versions = new JSONObject();
    protected String id;
    protected String markerClass;
    protected String installedPath;
    protected String installedVersion;
    protected String tempName;
    protected String destName;
    protected String name;
    protected String description;
    protected String screenshot;
    protected String helpLink;
    protected String vendor;
    protected String candidateVersion;
    protected String installerClass = null;
    protected List<String> componentClasses;
    protected boolean canUninstall = true;

    public Plugin(String aId) {
        this.id = aId;
    }

    public static Plugin fromJSON(JSONObject elm) {
        JSONArray componentsJSON;
        Plugin inst = new Plugin(elm.getString("id"));
        if (!(elm.get("markerClass") instanceof JSONNull)) {
            inst.markerClass = elm.getString("markerClass");
        }
        inst.componentClasses = new ArrayList<String>();
        if (inst.markerClass != null) {
            inst.componentClasses.add(inst.markerClass);
        }
        if (elm.containsKey("componentClasses") && (componentsJSON = elm.getJSONArray("componentClasses")).size() > 0) {
            for (int i = 0; i < componentsJSON.size(); ++i) {
                inst.componentClasses.add(componentsJSON.getString(i));
            }
        }
        if (elm.get("versions") instanceof JSONObject) {
            inst.versions = elm.getJSONObject("versions");
        }
        inst.name = elm.getString("name");
        inst.description = elm.getString("description");
        if (elm.containsKey("screenshotUrl")) {
            inst.screenshot = elm.getString("screenshotUrl");
        }
        inst.helpLink = elm.getString("helpUrl");
        inst.vendor = elm.getString("vendor");
        if (elm.containsKey("canUninstall")) {
            inst.canUninstall = elm.getBoolean("canUninstall");
        }
        if (elm.containsKey("installerClass")) {
            inst.installerClass = elm.getString("installerClass");
        }
        return inst;
    }

    public String toString() {
        return this.id;
    }

    public void detectInstalled(Set<Plugin> others) {
        if (this.isVirtual()) {
            this.detectInstalledVirtual(others);
        } else {
            this.detectInstalledPlugin();
        }
        this.candidateVersion = this.isInstalled() ? this.installedVersion : this.getMaxVersion();
    }

    private void detectInstalledPlugin() {
        this.installedPath = Plugin.getJARPath(this.markerClass);
        if (this.installedPath != null) {
            this.installedVersion = Plugin.getVersionFromPath(this.installedPath);
            if (this.installedVersion.equals(VER_STOCK) && this.isVersionFrozenToJMeter()) {
                this.installedVersion = Plugin.getJMeterVersion();
            }
            log.debug("Found plugin " + this + " version " + this.installedVersion + " at path " + this.installedPath);
        }
    }

    private void detectInstalledVirtual(Set<Plugin> others) {
        this.candidateVersion = this.getMaxVersion();
        log.debug("Detecting virtual " + this + " by depends: " + this.getDepends());
        for (String depID : this.getDepends()) {
            this.installedPath = null;
            for (Plugin plugin : others) {
                if (!plugin.getID().equals(depID) || !plugin.isInstalled()) continue;
                this.installedPath = "";
            }
            if (this.installedPath != null) continue;
            break;
        }
        if (this.isInstalled()) {
            this.installedVersion = this.candidateVersion;
        }
    }

    public boolean isVersionFrozenToJMeter() {
        return this.versions.containsKey("");
    }

    public String getMaxVersion() {
        Set<String> versions = this.getVersions();
        if (versions.size() > 0) {
            String[] vers = versions.toArray(new String[0]);
            return vers[vers.length - 1];
        }
        return null;
    }

    public Set<String> getVersions() {
        TreeSet<String> versions = new TreeSet<String>(new VersionComparator());
        for (Object o : this.versions.keySet()) {
            if (!(o instanceof String)) continue;
            String ver = (String)o;
            if (ver.isEmpty()) {
                versions.add(Plugin.getJMeterVersion());
                continue;
            }
            versions.add(ver);
        }
        if (this.isInstalled()) {
            versions.add(this.installedVersion);
        }
        return versions;
    }

    public static String getJMeterVersion() {
        String ver = JMeterUtils.getJMeterVersion();
        String[] parts = ver.split(" ");
        if (parts.length > 1) {
            return parts[0];
        }
        return ver;
    }

    public static String getVersionFromPath(String installedPath) {
        Pattern p = Pattern.compile("-([\\.0-9]+(-[\\w]+)?).jar");
        Matcher m = p.matcher(installedPath);
        if (m.find()) {
            return m.group(1);
        }
        return VER_STOCK;
    }

    public static String getJARPath(String className) {
        Class<?> cls;
        try {
            log.debug("Trying: " + className);
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException) {
                log.debug("Plugin not found by class: " + className);
            } else {
                log.warn("Unable to load class: " + className, e);
            }
            return null;
        }
        String file = cls.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (!file.toLowerCase().endsWith(".jar")) {
            log.warn("Path is not JAR: " + file);
        }
        return file;
    }

    public static String getLibInstallPath(String lib) {
        String[] cp = System.getProperty("java.class.path").split(File.pathSeparator);
        String path = Plugin.getLibPath(lib, cp);
        if (path != null) {
            return path;
        }
        return null;
    }

    public static String getLibPath(String lib, String[] paths) {
        for (String path : paths) {
            Pattern p = Pattern.compile("\\W" + lib + "-([0-9]+\\..+).jar");
            Matcher m = p.matcher(path);
            if (!m.find()) continue;
            log.debug("Found library " + lib + " at " + path);
            return path;
        }
        return null;
    }

    public String getID() {
        return this.id;
    }

    public String getInstalledPath() {
        return this.installedPath;
    }

    public String getDestName() {
        return this.destName;
    }

    public String getTempName() {
        return this.tempName;
    }

    public boolean isInstalled() {
        return this.installedPath != null;
    }

    public void download(JARSource jarSource, GenericCallback<String> notify) throws IOException {
        String location;
        if (this.isVirtual()) {
            log.debug("Virtual set, won't download: " + this);
            return;
        }
        String version = this.getCandidateVersion();
        if (this.isVersionFrozenToJMeter()) {
            String downloadUrl = this.versions.getJSONObject("").getString("downloadUrl");
            location = String.format(downloadUrl, Plugin.getJMeterVersion());
        } else {
            if (!this.versions.containsKey(version)) {
                throw new IllegalArgumentException("Version " + version + " not found for plugin " + this);
            }
            location = this.versions.getJSONObject(version).getString("downloadUrl");
        }
        JARSource.DownloadResult dwn = jarSource.getJAR(this.id, location, notify);
        this.tempName = dwn.getTmpFile();
        File f = new File(JMeterEngine.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        this.destName = URLDecoder.decode(f.getParent(), "UTF-8") + File.separator + dwn.getFilename();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getCandidateVersion() {
        return this.candidateVersion;
    }

    public boolean canUninstall() {
        return this.canUninstall;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setCandidateVersion(String candidateVersion) {
        this.candidateVersion = candidateVersion;
    }

    public boolean isUpgradable() {
        if (!this.isInstalled()) {
            return false;
        }
        VersionComparator comparator = new VersionComparator();
        return comparator.compare(this.getInstalledVersion(), this.getMaxVersion()) < 0;
    }

    public Set<String> getDepends() {
        HashSet<String> depends = new HashSet<String>();
        JSONObject version = this.versions.getJSONObject(this.getCandidateVersion());
        if (version.containsKey("depends")) {
            JSONArray list = version.getJSONArray("depends");
            for (Object o : list) {
                if (!(o instanceof String)) continue;
                String dep = (String)o;
                Matcher m = dependsParser.matcher(dep);
                if (!m.find()) {
                    throw new IllegalArgumentException("Cannot parse depend str: " + dep);
                }
                depends.add(m.group(1));
            }
        }
        return depends;
    }

    public Map<String, String> getLibs(String verStr) {
        HashMap<String, String> depends = new HashMap<String, String>();
        JSONObject version = this.versions.getJSONObject(verStr);
        if (version.containsKey("libs")) {
            JSONObject list = version.getJSONObject("libs");
            for (Object o : list.keySet()) {
                if (!(o instanceof String)) continue;
                String dep = (String)o;
                depends.put(dep, list.getString(dep));
            }
        }
        return depends;
    }

    public Map<String, String> getRequiredLibs(String verStr) {
        Map<String, String> libs = this.getLibs(verStr);
        HashMap<String, String> requiredLibs = new HashMap<String, String>();
        for (String libName : libs.keySet()) {
            if (!libName.contains(">=")) continue;
            requiredLibs.put(libName, libs.get(libName));
        }
        return requiredLibs;
    }

    public String getVersionChanges(String versionStr) {
        JSONObject version = this.versions.getJSONObject(versionStr);
        return version.containsKey("changes") ? version.getString("changes") : null;
    }

    public String getInstallerClass() {
        return this.installerClass;
    }

    public boolean containsComponentClasses(Set<String> classes) {
        for (String cls : this.componentClasses) {
            if (!classes.contains(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean isVirtual() {
        return this.markerClass == null;
    }

    private class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String a, String b) {
            String[] aParts = a.split("\\W+");
            String[] bParts = b.split("\\W+");
            for (int aN = 0; aN < aParts.length; ++aN) {
                int res;
                if (aN >= bParts.length || (res = this.compare2(aParts[aN], bParts[aN])) == 0) continue;
                return res;
            }
            return a.compareTo(b);
        }

        private int compare2(String a, String b) {
            Object bi;
            Object ai;
            if (a.equals(b)) {
                return 0;
            }
            try {
                ai = Integer.parseInt(a);
            }
            catch (NumberFormatException e) {
                ai = a;
            }
            try {
                bi = Integer.parseInt(b);
            }
            catch (NumberFormatException e) {
                bi = b;
            }
            if (ai instanceof Integer && bi instanceof Integer) {
                return Integer.compare((Integer)ai, (Integer)bi);
            }
            if (ai instanceof String && bi instanceof String) {
                return ((String)ai).compareTo((String)bi);
            }
            if (ai instanceof String) {
                return 1;
            }
            return -1;
        }
    }
}

