/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kg.apc.cmdtools.AbstractCMDTool;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;

public class PluginManagerCMD
extends AbstractCMDTool
implements GenericCallback<String> {
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected int processParams(ListIterator listIterator) throws UnsupportedOperationException, IllegalArgumentException {
        LoggingManager.setPriority((Priority)Priority.INFO);
        if (!listIterator.hasNext()) {
            this.showHelp(System.out);
            throw new IllegalArgumentException("Command parameter is missing");
        }
        String command = listIterator.next().toString();
        log.info("Command is: " + command);
        try {
            switch (command) {
                case "status": {
                    System.out.println(PluginManager.getAllPluginsStatus());
                    break;
                }
                case "install": {
                    this.process(listIterator, true);
                    break;
                }
                case "install-all-except": {
                    this.installAll(listIterator, true);
                    break;
                }
                case "uninstall": {
                    this.process(listIterator, false);
                    break;
                }
                case "help": {
                    this.showHelp(System.out);
                    break;
                }
                case "available": {
                    System.out.println(PluginManager.getAvailablePluginsAsString());
                    break;
                }
                case "upgrades": {
                    System.out.println(PluginManager.getUpgradablePluginsAsString());
                    break;
                }
                default: {
                    this.showHelp(System.out);
                    throw new UnsupportedOperationException("Wrong command: " + command);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to perform cmdline operation: " + e.getMessage(), e);
        }
        return 0;
    }

    private PluginManager getPluginsManager() throws Throwable {
        PluginManager mgr = new PluginManager();
        mgr.setTimeout(30000);
        mgr.load();
        return mgr;
    }

    protected void installAll(ListIterator exclusions, boolean install) throws Throwable {
        Set<Object> exceptedPlugins = Collections.emptySet();
        if (exclusions.hasNext()) {
            exceptedPlugins = this.parseParams(exclusions.next().toString()).keySet();
        }
        PluginManager mgr = this.getPluginsManager();
        for (Plugin plugin : mgr.getAvailablePlugins()) {
            if (exceptedPlugins.contains(plugin.getID())) continue;
            mgr.toggleInstalled(plugin, install);
        }
        mgr.applyChanges(this, false, null);
    }

    protected void process(ListIterator listIterator, boolean install) throws Throwable {
        if (!listIterator.hasNext()) {
            throw new IllegalArgumentException("Plugins list parameter is missing");
        }
        Map<String, String> params = this.parseParams(listIterator.next().toString());
        PluginManager mgr = this.getPluginsManager();
        for (Map.Entry<String, String> pluginSpec : params.entrySet()) {
            Plugin plugin = mgr.getPluginByID(pluginSpec.getKey());
            if (pluginSpec.getValue() != null) {
                plugin.setCandidateVersion(pluginSpec.getValue());
            }
            mgr.toggleInstalled(plugin, install);
        }
        mgr.applyChanges(this, false, null);
    }

    private Map<String, String> parseParams(String paramStr) {
        log.info("Params line is: " + paramStr);
        HashMap<String, String> res = new HashMap<String, String>();
        for (String part : paramStr.split(",")) {
            if (part.contains("=")) {
                String[] pieces = part.split("=");
                res.put(pieces[0].trim(), pieces[1].trim());
                continue;
            }
            res.put(part.trim(), null);
        }
        return res;
    }

    protected void showHelp(PrintStream printStream) {
        printStream.println("Options for tool 'PluginManagerCMD': <command> <paramstr>  where <command> is one of: help, status, available, upgrades, install, install-all-except, uninstall.");
    }

    @Override
    public void notify(String s) {
        if (s.endsWith("%")) {
            log.debug(s);
        } else {
            log.info(s);
        }
    }
}

