/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.util.JMeterToolBar;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginManagerDialog;
import org.jmeterplugins.repository.logging.LoggingHooker;
import org.jmeterplugins.repository.util.ComponentFinder;

public class PluginManagerMenuItem
extends JMenuItem
implements ActionListener {
    private static final long serialVersionUID = -8708638472918746046L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static PluginManagerDialog dialog;
    private final PluginManager mgr;

    public PluginManagerMenuItem() {
        super("Plugins Manager");
        this.addActionListener(this);
        this.mgr = new PluginManager();
        LoggingHooker hooker = new LoggingHooker(this.mgr);
        hooker.hook();
        try {
            this.mgr.load();
        }
        catch (Throwable e) {
            log.warn("Failed to load plugin updates info", e);
        }
        if (this.mgr.hasAnyUpdates()) {
            this.setText("Plugins Manager (has upgrades)");
            log.info("Plugins Manager has upgrades: " + Arrays.toString(this.mgr.getUpgradablePlugins().toArray()));
        }
        this.addToolbarIcon();
        this.setIcon(PluginManagerMenuItem.getPluginsIcon(this.mgr.hasAnyUpdates()));
    }

    private void addToolbarIcon() {
        GuiPackage instance = GuiPackage.getInstance();
        if (instance != null) {
            final MainFrame mf = instance.getMainFrame();
            final ComponentFinder<JMeterToolBar> finder = new ComponentFinder<JMeterToolBar>(JMeterToolBar.class);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMeterToolBar toolbar = null;
                    while (toolbar == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            log.debug("Did not add btn to toolbar", (Throwable)e);
                        }
                        log.debug("Searching for toolbar");
                        toolbar = (JMeterToolBar)finder.findComponentIn((Container)mf);
                    }
                    Component toolbarButton = PluginManagerMenuItem.this.getToolbarButton();
                    int pos = toolbar.getComponents().length - 1;
                    toolbarButton.setSize(toolbar.getComponent(pos).getSize());
                    toolbar.add(toolbarButton, pos + 1);
                }
            });
        }
    }

    private Component getToolbarButton() {
        JButton button = new JButton(PluginManagerMenuItem.getIcon22Px(this.mgr.hasAnyUpdates()));
        button.setToolTipText("Plugins Manager (has upgrades)");
        button.addActionListener(this);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (dialog == null) {
            int timeout = Integer.parseInt(JMeterUtils.getPropDefault((String)"jpgc.repo.timeout", (String)"30000"));
            this.mgr.setTimeout(timeout);
            dialog = new PluginManagerDialog(this.mgr);
        }
        dialog.pack();
        dialog.setVisible(true);
    }

    public static ImageIcon getIcon22Px(boolean hasUpdates) {
        if (hasUpdates) {
            return new ImageIcon(PluginManagerMenuItem.class.getResource("/org/jmeterplugins/logo22Update.png"));
        }
        return new ImageIcon(PluginManagerMenuItem.class.getResource("/org/jmeterplugins/logo22.png"));
    }

    public static ImageIcon getPluginsIcon(boolean hasUpdates) {
        if (hasUpdates) {
            return new ImageIcon(PluginManagerMenuItem.class.getResource("/org/jmeterplugins/logoUpdate.png"));
        }
        return new ImageIcon(PluginManagerMenuItem.class.getResource("/org/jmeterplugins/logo.png"));
    }
}

