/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository.plugins;

import java.awt.Frame;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.plugins.SuggestDialog;
import org.jmeterplugins.repository.plugins.TestPlanAnalyzer;

public class PluginSuggester {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected TestPlanAnalyzer analyzer;
    protected String testPlan;
    private final PluginManager pmgr;

    public PluginSuggester(PluginManager pmgr) {
        this.pmgr = pmgr;
        this.analyzer = new TestPlanAnalyzer();
    }

    public void checkAndSuggest(String msg) {
        Set<Plugin> pluginsToInstall = this.findPluginsToInstall(msg);
        if (pluginsToInstall.size() > 0) {
            this.pmgr.togglePlugins(pluginsToInstall, true);
            MainFrame parent = GuiPackage.getInstance() != null ? GuiPackage.getInstance().getMainFrame() : null;
            SuggestDialog dialog = new SuggestDialog((Frame)parent, this.pmgr, pluginsToInstall, this.testPlan);
            dialog.setVisible(true);
            dialog.setAlwaysOnTop(true);
        }
    }

    protected Set<Plugin> findPluginsToInstall(String msg) {
        if (msg != null && msg.contains("Loading file")) {
            Set<String> nonExistentClasses;
            this.testPlan = msg.substring(msg.indexOf(": ") + 2);
            if (!"null".equals(this.testPlan) && (nonExistentClasses = this.analyzer.analyze(this.testPlan)).size() > 0) {
                return this.findPluginsFromClasses(nonExistentClasses);
            }
        }
        return Collections.emptySet();
    }

    protected void togglePlugins(Set<Plugin> pluginsToInstall) {
        for (Plugin plugin : pluginsToInstall) {
            this.pmgr.toggleInstalled(plugin, true);
        }
    }

    protected Set<Plugin> findPluginsFromClasses(Set<String> nonExistentClasses) {
        try {
            this.pmgr.load();
        }
        catch (Throwable throwable) {
            log.warn("Cannot load plugins repo: ", throwable);
            return Collections.emptySet();
        }
        Set<Plugin> availablePlugins = this.pmgr.getAvailablePlugins();
        HashSet<Plugin> pluginsToInstall = new HashSet<Plugin>();
        for (Plugin plugin : availablePlugins) {
            if (!plugin.containsComponentClasses(nonExistentClasses)) continue;
            pluginsToInstall.add(plugin);
        }
        if (pluginsToInstall.isEmpty()) {
            log.warn("Plugins Manager were unable to find plugins to satisfy Test Plan requirements. To help improve, please report following list to https://jmeter-plugins.org/support/: " + Arrays.toString(nonExistentClasses.toArray()));
        }
        return pluginsToInstall;
    }

    public TestPlanAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(TestPlanAnalyzer analyzer) {
        this.analyzer = analyzer;
    }
}

